package pf::extended_node_data;

=head1 NAME

pf::extended_node_data -

=cut

=head1 DESCRIPTION

pf::extended_node_data

=cut

use strict;
use warnings;
use pf::Redis;
use JSON::MaybeXS;
use Exporter qw(import);

BEGIN {
    our @EXPORT = qw(extended_node_get_data);
}

=head2 extended_node_get_data

Get the node extended data

=cut

sub extended_node_get_data {
    my ($mac, $namespace) = @_;
    my $redis = pf::Redis->new(server => '127.0.0.1:6379');
    my $json = JSON::MaybeXS->new;
    my ($text) = $redis->get("extended:${namespace}:${mac}");
    if (defined $text) {
        return $json->decode($text);
    }
    return undef;
}


 
=head1 AUTHOR

Inverse inc. <info@inverse.ca>

=head1 COPYRIGHT

Copyright (C) 2005-2018 Inverse inc.

=head1 LICENSE

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
USA.

=cut

1;
