/*! URI.js v1.9.1 http://medialize.github.com/URI.js/ */
/* build contains: URI.js, URITemplate.js */
(function(k,m){"object"===typeof exports?module.exports=m(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains")):"function"===typeof define&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],m):k.URI=m(k.punycode,k.IPv6,k.SecondLevelDomains)})(this,function(k,m,u){function e(a,b){if(!(this instanceof e))return new e(a,b);void 0===a&&(a="undefined"!==typeof location?location.href+"":"");this.href(a);return void 0!==b?this.absoluteTo(b):this}function t(a){return a.replace(/([.*+?^=!:${}()|[\]\/\\])/g,
"\\$1")}function v(a){return"[object Array]"===String(Object.prototype.toString.call(a))}function f(a){return encodeURIComponent(a).replace(/[!'()*]/g,escape).replace(/\*/g,"%2A")}var c=e.prototype,l=Object.prototype.hasOwnProperty;e._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,duplicateQueryParameters:e.duplicateQueryParameters}};e.duplicateQueryParameters=!1;e.protocol_expression=/^[a-z][a-z0-9-+-]*$/i;e.idn_expression=
/[^a-z0-9\.-]/i;e.punycode_expression=/(xn--)/i;e.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;e.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
e.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))/ig;e.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};e.invalid_hostname_characters=/[^a-zA-Z0-9\.-]/;e.encode=f;e.decode=decodeURIComponent;e.iso8859=function(){e.encode=escape;e.decode=unescape};e.unicode=function(){e.encode=
f;e.decode=decodeURIComponent};e.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+",
"%2C":",","%3B":";","%3D":"="}}}};e.encodeQuery=function(a){return e.encode(a+"").replace(/%20/g,"+")};e.decodeQuery=function(a){return e.decode((a+"").replace(/\+/g,"%20"))};e.recodePath=function(a){a=(a+"").split("/");for(var b=0,d=a.length;b<d;b++)a[b]=e.encodePathSegment(e.decode(a[b]));return a.join("/")};e.decodePath=function(a){a=(a+"").split("/");for(var b=0,d=a.length;b<d;b++)a[b]=e.decodePathSegment(a[b]);return a.join("/")};var p={encode:"encode",decode:"decode"},r,n=function(a,b){return function(d){return e[b](d+
"").replace(e.characters[a][b].expression,function(d){return e.characters[a][b].map[d]})}};for(r in p)e[r+"PathSegment"]=n("pathname",p[r]);e.encodeReserved=n("reserved","encode");e.parse=function(a,b){var d;b||(b={});d=a.indexOf("#");-1<d&&(b.fragment=a.substring(d+1)||null,a=a.substring(0,d));d=a.indexOf("?");-1<d&&(b.query=a.substring(d+1)||null,a=a.substring(0,d));"//"===a.substring(0,2)?(b.protocol="",a=a.substring(2),a=e.parseAuthority(a,b)):(d=a.indexOf(":"),-1<d&&(b.protocol=a.substring(0,
d),b.protocol&&!b.protocol.match(e.protocol_expression)?b.protocol=void 0:"file"===b.protocol?a=a.substring(d+3):"//"===a.substring(d+1,d+3)?(a=a.substring(d+3),a=e.parseAuthority(a,b)):(a=a.substring(d+1),b.urn=!0)));b.path=a;return b};e.parseHost=function(a,b){var d=a.indexOf("/"),g;-1===d&&(d=a.length);"["===a.charAt(0)?(g=a.indexOf("]"),b.hostname=a.substring(1,g)||null,b.port=a.substring(g+2,d)||null):a.indexOf(":")!==a.lastIndexOf(":")?(b.hostname=a.substring(0,d)||null,b.port=null):(g=a.substring(0,
d).split(":"),b.hostname=g[0]||null,b.port=g[1]||null);b.hostname&&"/"!==a.substring(d).charAt(0)&&(d++,a="/"+a);return a.substring(d)||"/"};e.parseAuthority=function(a,b){a=e.parseUserinfo(a,b);return e.parseHost(a,b)};e.parseUserinfo=function(a,b){var d=a.indexOf("@"),g=a.indexOf("/");-1<d&&(-1===g||d<g)?(g=a.substring(0,d).split(":"),b.username=g[0]?e.decode(g[0]):null,g.shift(),b.password=g[0]?e.decode(g.join(":")):null,a=a.substring(d+1)):(b.username=null,b.password=null);return a};e.parseQuery=
function(a){if(!a)return{};a=a.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!a)return{};var b={};a=a.split("&");for(var d=a.length,g,c,f=0;f<d;f++)g=a[f].split("="),c=e.decodeQuery(g.shift()),g=g.length?e.decodeQuery(g.join("=")):null,b[c]?("string"===typeof b[c]&&(b[c]=[b[c]]),b[c].push(g)):b[c]=g;return b};e.build=function(a){var b="";a.protocol&&(b+=a.protocol+":");if(!a.urn&&(b||a.hostname))b+="//";b+=e.buildAuthority(a)||"";"string"===typeof a.path&&("/"!==a.path.charAt(0)&&"string"===typeof a.hostname&&
(b+="/"),b+=a.path);"string"===typeof a.query&&a.query&&(b+="?"+a.query);"string"===typeof a.fragment&&a.fragment&&(b+="#"+a.fragment);return b};e.buildHost=function(a){var b="";if(a.hostname)e.ip6_expression.test(a.hostname)?b=a.port?b+("["+a.hostname+"]:"+a.port):b+a.hostname:(b+=a.hostname,a.port&&(b+=":"+a.port));else return"";return b};e.buildAuthority=function(a){return e.buildUserinfo(a)+e.buildHost(a)};e.buildUserinfo=function(a){var b="";a.username&&(b+=e.encode(a.username),a.password&&(b+=
":"+e.encode(a.password)),b+="@");return b};e.buildQuery=function(a,b){var d="",g,c,f,h;for(c in a)if(l.call(a,c)&&c)if(v(a[c])){g={};f=0;for(h=a[c].length;f<h;f++)void 0!==a[c][f]&&void 0===g[a[c][f]+""]&&(d+="&"+e.buildQueryParameter(c,a[c][f]),!0!==b&&(g[a[c][f]+""]=!0))}else void 0!==a[c]&&(d+="&"+e.buildQueryParameter(c,a[c]));return d.substring(1)};e.buildQueryParameter=function(a,b){return e.encodeQuery(a)+(null!==b?"="+e.encodeQuery(b):"")};e.addQuery=function(a,b,d){if("object"===typeof b)for(var g in b)l.call(b,
g)&&e.addQuery(a,g,b[g]);else if("string"===typeof b)void 0===a[b]?a[b]=d:("string"===typeof a[b]&&(a[b]=[a[b]]),v(d)||(d=[d]),a[b]=a[b].concat(d));else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");};e.removeQuery=function(a,b,d){var g;if(v(b)){d=0;for(g=b.length;d<g;d++)a[b[d]]=void 0}else if("object"===typeof b)for(g in b)l.call(b,g)&&e.removeQuery(a,g,b[g]);else if("string"===typeof b)if(void 0!==d)if(a[b]===d)a[b]=void 0;else{if(v(a[b])){g=a[b];var c={},
f,h;if(v(d)){f=0;for(h=d.length;f<h;f++)c[d[f]]=!0}else c[d]=!0;f=0;for(h=g.length;f<h;f++)void 0!==c[g[f]]&&(g.splice(f,1),h--,f--);a[b]=g}}else a[b]=void 0;else throw new TypeError("URI.addQuery() accepts an object, string as the first parameter");};e.commonPath=function(a,b){var d=Math.min(a.length,b.length),g;for(g=0;g<d;g++)if(a.charAt(g)!==b.charAt(g)){g--;break}if(1>g)return a.charAt(0)===b.charAt(0)&&"/"===a.charAt(0)?"/":"";"/"!==a.charAt(g)&&(g=a.substring(0,g).lastIndexOf("/"));return a.substring(0,
g+1)};e.withinString=function(a,b){return a.replace(e.find_uri_expression,b)};e.ensureValidHostname=function(a){if(a.match(e.invalid_hostname_characters)){if(!k)throw new TypeError("Hostname '"+a+"' contains characters other than [A-Z0-9.-] and Punycode.js is not available");if(k.toASCII(a).match(e.invalid_hostname_characters))throw new TypeError("Hostname '"+a+"' contains characters other than [A-Z0-9.-]");}};c.build=function(a){if(!0===a)this._deferred_build=!0;else if(void 0===a||this._deferred_build)this._string=
e.build(this._parts),this._deferred_build=!1;return this};c.clone=function(){return new e(this)};c.valueOf=c.toString=function(){return this.build(!1)._string};p={protocol:"protocol",username:"username",password:"password",hostname:"hostname",port:"port"};n=function(a){return function(b,d){if(void 0===b)return this._parts[a]||"";this._parts[a]=b;this.build(!d);return this}};for(r in p)c[r]=n(p[r]);p={query:"?",fragment:"#"};n=function(a,b){return function(d,g){if(void 0===d)return this._parts[a]||
"";null!==d&&(d+="",d.charAt(0)===b&&(d=d.substring(1)));this._parts[a]=d;this.build(!g);return this}};for(r in p)c[r]=n(r,p[r]);p={search:["?","query"],hash:["#","fragment"]};n=function(a,b){return function(d,g){var e=this[a](d,g);return"string"===typeof e&&e.length?b+e:e}};for(r in p)c[r]=n(p[r][1],p[r][0]);c.pathname=function(a,b){if(void 0===a||!0===a){var d=this._parts.path||(this._parts.urn?"":"/");return a?e.decodePath(d):d}this._parts.path=a?e.recodePath(a):"/";this.build(!b);return this};
c.path=c.pathname;c.href=function(a,b){var d;if(void 0===a)return this.toString();this._string="";this._parts=e._parts();var g=a instanceof e,c="object"===typeof a&&(a.hostname||a.path);!g&&(c&&void 0!==a.pathname)&&(a=a.toString());if("string"===typeof a)this._parts=e.parse(a,this._parts);else if(g||c)for(d in g=g?a._parts:a,g)l.call(this._parts,d)&&(this._parts[d]=g[d]);else throw new TypeError("invalid input");this.build(!b);return this};c.is=function(a){var b=!1,d=!1,g=!1,c=!1,f=!1,h=!1,l=!1,
j=!this._parts.urn;this._parts.hostname&&(j=!1,d=e.ip4_expression.test(this._parts.hostname),g=e.ip6_expression.test(this._parts.hostname),b=d||g,f=(c=!b)&&u&&u.has(this._parts.hostname),h=c&&e.idn_expression.test(this._parts.hostname),l=c&&e.punycode_expression.test(this._parts.hostname));switch(a.toLowerCase()){case "relative":return j;case "absolute":return!j;case "domain":case "name":return c;case "sld":return f;case "ip":return b;case "ip4":case "ipv4":case "inet4":return d;case "ip6":case "ipv6":case "inet6":return g;
case "idn":return h;case "url":return!this._parts.urn;case "urn":return!!this._parts.urn;case "punycode":return l}return null};var j=c.protocol,h=c.port,s=c.hostname;c.protocol=function(a,b){if(void 0!==a&&a&&(a=a.replace(/:(\/\/)?$/,""),a.match(/[^a-zA-z0-9\.+-]/)))throw new TypeError("Protocol '"+a+"' contains characters other than [A-Z0-9.+-]");return j.call(this,a,b)};c.scheme=c.protocol;c.port=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0!==a&&(0===a&&(a=null),a&&(a+="",
":"===a.charAt(0)&&(a=a.substring(1)),a.match(/[^0-9]/))))throw new TypeError("Port '"+a+"' contains characters other than [0-9]");return h.call(this,a,b)};c.hostname=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0!==a){var d={};e.parseHost(a,d);a=d.hostname}return s.call(this,a,b)};c.host=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?e.buildHost(this._parts):"";e.parseHost(a,this._parts);this.build(!b);return this};c.authority=
function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?e.buildAuthority(this._parts):"";e.parseAuthority(a,this._parts);this.build(!b);return this};c.userinfo=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){if(!this._parts.username)return"";var d=e.buildUserinfo(this._parts);return d.substring(0,d.length-1)}"@"!==a[a.length-1]&&(a+="@");e.parseUserinfo(a,this._parts);this.build(!b);return this};c.resource=function(a,b){var d;
if(void 0===a)return this.path()+this.search()+this.hash();d=e.parse(a);this._parts.path=d.path;this._parts.query=d.query;this._parts.fragment=d.fragment;this.build(!b);return this};c.subdomain=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var d=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,d)||""}d=this._parts.hostname.length-this.domain().length;d=this._parts.hostname.substring(0,
d);d=RegExp("^"+t(d));a&&"."!==a.charAt(a.length-1)&&(a+=".");a&&e.ensureValidHostname(a);this._parts.hostname=this._parts.hostname.replace(d,a);this.build(!b);return this};c.domain=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var d=this._parts.hostname.match(/\./g);if(d&&2>d.length)return this._parts.hostname;d=this._parts.hostname.length-this.tld(b).length-1;d=this._parts.hostname.lastIndexOf(".",
d-1)+1;return this._parts.hostname.substring(d)||""}if(!a)throw new TypeError("cannot set domain empty");e.ensureValidHostname(a);!this._parts.hostname||this.is("IP")?this._parts.hostname=a:(d=RegExp(t(this.domain())+"$"),this._parts.hostname=this._parts.hostname.replace(d,a));this.build(!b);return this};c.tld=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var d=this._parts.hostname.lastIndexOf("."),
d=this._parts.hostname.substring(d+1);return!0!==b&&u&&u.list[d.toLowerCase()]?u.get(this._parts.hostname)||d:d}if(a)if(a.match(/[^a-zA-Z0-9-]/))if(u&&u.is(a))d=RegExp(t(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(d,a);else throw new TypeError("TLD '"+a+"' contains characters other than [A-Z0-9]");else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");d=RegExp(t(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(d,
a)}else throw new TypeError("cannot set TLD empty");this.build(!b);return this};c.directory=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var d=this._parts.path.length-this.filename().length-1,d=this._parts.path.substring(0,d)||(this._parts.hostname?"/":"");return a?e.decodePath(d):d}d=this._parts.path.length-this.filename().length;d=this._parts.path.substring(0,d);d=RegExp("^"+
t(d));this.is("relative")||(a||(a="/"),"/"!==a.charAt(0)&&(a="/"+a));a&&"/"!==a.charAt(a.length-1)&&(a+="/");a=e.recodePath(a);this._parts.path=this._parts.path.replace(d,a);this.build(!b);return this};c.filename=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path||"/"===this._parts.path)return"";var d=this._parts.path.lastIndexOf("/"),d=this._parts.path.substring(d+1);return a?e.decodePathSegment(d):d}d=!1;"/"===a.charAt(0)&&(a=a.substring(1));a.match(/\.?\//)&&
(d=!0);var g=RegExp(t(this.filename())+"$");a=e.recodePath(a);this._parts.path=this._parts.path.replace(g,a);d?this.normalizePath(b):this.build(!b);return this};c.suffix=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path||"/"===this._parts.path)return"";var d=this.filename(),g=d.lastIndexOf(".");if(-1===g)return"";d=d.substring(g+1);d=/^[a-z0-9%]+$/i.test(d)?d:"";return a?e.decodePathSegment(d):d}"."===a.charAt(0)&&(a=a.substring(1));if(d=this.suffix())g=
a?RegExp(t(d)+"$"):RegExp(t("."+d)+"$");else{if(!a)return this;this._parts.path+="."+e.recodePath(a)}g&&(a=e.recodePath(a),this._parts.path=this._parts.path.replace(g,a));this.build(!b);return this};c.segment=function(a,b,d){var e=this._parts.urn?":":"/",c=this.path(),f="/"===c.substring(0,1),c=c.split(e);"number"!==typeof a&&(d=b,b=a,a=void 0);if(void 0!==a&&"number"!==typeof a)throw Error("Bad segment '"+a+"', must be 0-based integer");f&&c.shift();0>a&&(a=Math.max(c.length+a,0));if(void 0===b)return void 0===
a?c:c[a];if(null===a||void 0===c[a])if(v(b))c=b;else{if(b||"string"===typeof b&&b.length)""===c[c.length-1]?c[c.length-1]=b:c.push(b)}else b||"string"===typeof b&&b.length?c[a]=b:c.splice(a,1);f&&c.unshift("");return this.path(c.join(e),d)};var q=c.query;c.query=function(a,b){if(!0===a)return e.parseQuery(this._parts.query);if("function"===typeof a){var d=e.parseQuery(this._parts.query),c=a.call(this,d);this._parts.query=e.buildQuery(c||d,this._parts.duplicateQueryParameters);this.build(!b);return this}return void 0!==
a&&"string"!==typeof a?(this._parts.query=e.buildQuery(a,this._parts.duplicateQueryParameters),this.build(!b),this):q.call(this,a,b)};c.setQuery=function(a,b,d){var c=e.parseQuery(this._parts.query);if("object"===typeof a)for(var f in a)l.call(a,f)&&(c[f]=a[f]);else if("string"===typeof a)c[a]=void 0!==b?b:null;else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");this._parts.query=e.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(d=b);
this.build(!d);return this};c.addQuery=function(a,b,d){var c=e.parseQuery(this._parts.query);e.addQuery(c,a,void 0===b?null:b);this._parts.query=e.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(d=b);this.build(!d);return this};c.removeQuery=function(a,b,d){var c=e.parseQuery(this._parts.query);e.removeQuery(c,a,b);this._parts.query=e.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(d=b);this.build(!d);return this};c.setSearch=c.setQuery;c.addSearch=
c.addQuery;c.removeSearch=c.removeQuery;c.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()};c.normalizeProtocol=function(a){"string"===typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!a));return this};c.normalizeHostname=function(a){this._parts.hostname&&
(this.is("IDN")&&k?this._parts.hostname=k.toASCII(this._parts.hostname):this.is("IPv6")&&m&&(this._parts.hostname=m.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!a));return this};c.normalizePort=function(a){"string"===typeof this._parts.protocol&&this._parts.port===e.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!a));return this};c.normalizePath=function(a){if(this._parts.urn||!this._parts.path||"/"===this._parts.path)return this;
var b,d,c=this._parts.path,f,h;"/"!==c.charAt(0)&&("."===c.charAt(0)&&(d=c.substring(0,c.indexOf("/"))),b=!0,c="/"+c);for(c=c.replace(/(\/(\.\/)+)|\/{2,}/g,"/");;){f=c.indexOf("/../");if(-1===f)break;else if(0===f){c=c.substring(3);break}h=c.substring(0,f).lastIndexOf("/");-1===h&&(h=f);c=c.substring(0,h)+c.substring(f+3)}b&&this.is("relative")&&(c=d?d+c:c.substring(1));c=e.recodePath(c);this._parts.path=c;this.build(!a);return this};c.normalizePathname=c.normalizePath;c.normalizeQuery=function(a){"string"===
typeof this._parts.query&&(this._parts.query.length?this.query(e.parseQuery(this._parts.query)):this._parts.query=null,this.build(!a));return this};c.normalizeFragment=function(a){this._parts.fragment||(this._parts.fragment=null,this.build(!a));return this};c.normalizeSearch=c.normalizeQuery;c.normalizeHash=c.normalizeFragment;c.iso8859=function(){var a=e.encode,b=e.decode;e.encode=escape;e.decode=decodeURIComponent;this.normalize();e.encode=a;e.decode=b;return this};c.unicode=function(){var a=e.encode,
b=e.decode;e.encode=f;e.decode=unescape;this.normalize();e.encode=a;e.decode=b;return this};c.readable=function(){var a=this.clone();a.username("").password("").normalize();var b="";a._parts.protocol&&(b+=a._parts.protocol+"://");a._parts.hostname&&(a.is("punycode")&&k?(b+=k.toUnicode(a._parts.hostname),a._parts.port&&(b+=":"+a._parts.port)):b+=a.host());a._parts.hostname&&(a._parts.path&&"/"!==a._parts.path.charAt(0))&&(b+="/");b+=a.path(!0);if(a._parts.query){for(var d="",c=0,f=a._parts.query.split("&"),
h=f.length;c<h;c++){var l=(f[c]||"").split("="),d=d+("&"+e.decodeQuery(l[0]).replace(/&/g,"%26"));void 0!==l[1]&&(d+="="+e.decodeQuery(l[1]).replace(/&/g,"%26"))}b+="?"+d.substring(1)}return b+=a.hash()};c.absoluteTo=function(a){var b=this.clone(),d=["protocol","username","password","hostname","port"],c,f;if(this._parts.urn)throw Error("URNs do not have any generally defined hierachical components");if(this._parts.hostname)return b;a instanceof e||(a=new e(a));c=0;for(f;f=d[c];c++)b._parts[f]=a._parts[f];
d=["query","path"];c=0;for(f;f=d[c];c++)!b._parts[f]&&a._parts[f]&&(b._parts[f]=a._parts[f]);"/"!==b.path().charAt(0)&&(a=a.directory(),b._parts.path=(a?a+"/":"")+b._parts.path,b.normalizePath());b.build();return b};c.relativeTo=function(a){var b=this.clone(),d=["protocol","username","password","hostname","port"],c;if(this._parts.urn)throw Error("URNs do not have any generally defined hierachical components");a instanceof e||(a=new e(a));if("/"!==this.path().charAt(0)||"/"!==a.path().charAt(0))throw Error("Cannot calculate common path from non-relative URLs");
c=e.commonPath(b.path(),a.path());if(!c||"/"===c)return b;for(var f=0,h;h=d[f];f++)b._parts[h]=null;a=a.directory();d=this.directory();if(a===d)return b._parts.path="./"+b.filename(),b.build();a.substring(c.length);d=d.substring(c.length);if(a+"/"===c)return d&&(d+="/"),b._parts.path="./"+d+b.filename(),b.build();d="../";c=RegExp("^"+t(c));for(a=a.replace(c,"/").match(/\//g).length-1;a--;)d+="../";b._parts.path=b._parts.path.replace(c,d);return b.build()};c.equals=function(a){var b=this.clone(),c=
new e(a),f={},h={};a={};var j;b.normalize();c.normalize();if(b.toString()===c.toString())return!0;f=b.query();h=c.query();b.query("");c.query("");if(b.toString()!==c.toString()||f.length!==h.length)return!1;f=e.parseQuery(f);h=e.parseQuery(h);for(j in f)if(l.call(f,j)){if(v(f[j])){if(!v(h[j])||f[j].length!==h[j].length)return!1;f[j].sort();h[j].sort();b=0;for(c=f[j].length;b<c;b++)if(f[j][b]!==h[j][b])return!1}else if(f[j]!==h[j])return!1;a[j]=!0}for(j in h)if(l.call(h,j)&&!a[j])return!1;return!0};
c.duplicateQueryParameters=function(a){this._parts.duplicateQueryParameters=!!a;return this};return e});
(function(k,m){"object"===typeof exports?module.exports=m(require("./URI")):"function"===typeof define&&define.amd?define(["./URI"],m):k.URITemplate=m(k.URI)})(this,function(k){function m(e){if(m._cache[e])return m._cache[e];if(!(this instanceof m))return new m(e);this.expression=e;m._cache[e]=this;return this}function u(e){this.data=e;this.cache={}}var e=Object.prototype.hasOwnProperty,t=m.prototype,v={"":{prefix:"",separator:",",named:!1,empty_name_separator:!1,encode:"encode"},"+":{prefix:"",separator:",",
named:!1,empty_name_separator:!1,encode:"encodeReserved"},"#":{prefix:"#",separator:",",named:!1,empty_name_separator:!1,encode:"encodeReserved"},".":{prefix:".",separator:".",named:!1,empty_name_separator:!1,encode:"encode"},"/":{prefix:"/",separator:"/",named:!1,empty_name_separator:!1,encode:"encode"},";":{prefix:";",separator:";",named:!0,empty_name_separator:!1,encode:"encode"},"?":{prefix:"?",separator:"&",named:!0,empty_name_separator:!0,encode:"encode"},"&":{prefix:"&",separator:"&",named:!0,
empty_name_separator:!0,encode:"encode"}};m._cache={};m.EXPRESSION_PATTERN=/\{([^a-zA-Z0-9%_]?)([^\}]+)(\}|$)/g;m.VARIABLE_PATTERN=/^([^*:]+)((\*)|:(\d+))?$/;m.VARIABLE_NAME_PATTERN=/[^a-zA-Z0-9%_]/;m.expand=function(e,c){var l=v[e.operator],p=l.named?"Named":"Unnamed",r=e.variables,n=[],j,h,k;for(k=0;h=r[k];k++)j=c.get(h.name),j.val.length?n.push(m["expand"+p](j,l,h.explode,h.explode&&l.separator||",",h.maxlength,h.name)):j.type&&n.push("");return n.length?l.prefix+n.join(l.separator):""};m.expandNamed=
function(e,c,l,p,r,n){var j="",h=c.encode;c=c.empty_name_separator;var m=!e[h].length,q=2===e.type?"":k[h](n),a,b,d;b=0;for(d=e.val.length;b<d;b++)r?(a=k[h](e.val[b][1].substring(0,r)),2===e.type&&(q=k[h](e.val[b][0].substring(0,r)))):m?(a=k[h](e.val[b][1]),2===e.type?(q=k[h](e.val[b][0]),e[h].push([q,a])):e[h].push([void 0,a])):(a=e[h][b][1],2===e.type&&(q=e[h][b][0])),j&&(j+=p),l?j+=q+(c||a?"=":"")+a:(b||(j+=k[h](n)+(c||a?"=":"")),2===e.type&&(j+=q+","),j+=a);return j};m.expandUnnamed=function(e,
c,l,p,m){var n="",j=c.encode;c=c.empty_name_separator;var h=!e[j].length,s,q,a,b;a=0;for(b=e.val.length;a<b;a++)m?q=k[j](e.val[a][1].substring(0,m)):h?(q=k[j](e.val[a][1]),e[j].push([2===e.type?k[j](e.val[a][0]):void 0,q])):q=e[j][a][1],n&&(n+=p),2===e.type&&(s=m?k[j](e.val[a][0].substring(0,m)):e[j][a][0],n+=s,n=l?n+(c||q?"=":""):n+","),n+=q;return n};t.expand=function(e){var c="";(!this.parts||!this.parts.length)&&this.parse();e instanceof u||(e=new u(e));for(var l=0,p=this.parts.length;l<p;l++)c+=
"string"===typeof this.parts[l]?this.parts[l]:m.expand(this.parts[l],e);return c};t.parse=function(){var e=this.expression,c=m.EXPRESSION_PATTERN,l=m.VARIABLE_PATTERN,p=m.VARIABLE_NAME_PATTERN,k=[],n=0,j,h,s;for(c.lastIndex=0;;){h=c.exec(e);if(null===h){k.push(e.substring(n));break}else k.push(e.substring(n,h.index)),n=h.index+h[0].length;if(v[h[1]]){if(!h[3])throw Error('Unclosed Expression "'+h[0]+'"');}else throw Error('Unknown Operator "'+h[1]+'" in "'+h[0]+'"');j=h[2].split(",");for(var q=0,
a=j.length;q<a;q++){s=j[q].match(l);if(null===s)throw Error('Invalid Variable "'+j[q]+'" in "'+h[0]+'"');if(s[1].match(p))throw Error('Invalid Variable Name "'+s[1]+'" in "'+h[0]+'"');j[q]={name:s[1],explode:!!s[3],maxlength:s[4]&&parseInt(s[4],10)}}if(!j.length)throw Error('Expression Missing Variable(s) "'+h[0]+'"');k.push({expression:h[0],operator:h[1],variables:j})}k.length||k.push(e);this.parts=k;return this};u.prototype.get=function(f){var c=this.data,l={type:0,val:[],encode:[],encodeReserved:[]},
k;if(void 0!==this.cache[f])return this.cache[f];this.cache[f]=l;c="[object Function]"===String(Object.prototype.toString.call(c))?c(f):"[object Function]"===String(Object.prototype.toString.call(c[f]))?c[f](f):c[f];if(!(void 0===c||null===c))if("[object Array]"===String(Object.prototype.toString.call(c))){k=0;for(f=c.length;k<f;k++)void 0!==c[k]&&null!==c[k]&&l.val.push([void 0,String(c[k])]);l.val.length&&(l.type=3)}else if("[object Object]"===String(Object.prototype.toString.call(c))){for(k in c)e.call(c,
k)&&(void 0!==c[k]&&null!==c[k])&&l.val.push([k,String(c[k])]);l.val.length&&(l.type=2)}else l.type=1,l.val.push([void 0,String(c)]);return l};k.expand=function(e,c){var l=(new m(e)).expand(c);return new k(l)};return m});

