#!/bin/bash

regex=`sqlite3 /usr/local/fingerbank/db/fingerbank_Upstream.db "select mac from mac_vendor where name like '%samsung%' or name like '%Murata%';" | perl -pe 's/([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})/$1:$2:$3/g' | tr '\n' '|' | sed 's/|$//g'`
regex="^($regex)"

read -r -d '' content <<EOF
### SAMSUNG MAC VENDOR CHECK FOR CAPTIVE-PORTAL DO NOT REPLACE ANYTHING BELOW THIS LINE UNTIL THIS BLOCK ENDS
### THIS GETS GENERATED BY 'make update_samsung_dns_filter'
[samsung_oui]
filter = mac
operator = regex
value = $regex

[connectivitycheck_gstatic_com]
filter = qname
operator = match
value = connectivitycheck.gstatic.com

[registration_samsung_connectivitycheck_gstatic_com:connectivitycheck_gstatic_com&samsung_oui]
scope = registration
answer = connectivitycheck.gstatic.com IN A 172.217.13.99
rcode = NOERROR

[dnsenforcement_samsung_connectivitycheck_gstatic_com:connectivitycheck_gstatic_com&samsung_oui]
scope = dnsenforcement
answer = connectivitycheck.gstatic.com IN A 172.217.13.99
rcode = NOERROR

[inline_samsung_connectivitycheck_gstatic_com:connectivitycheck_gstatic_com&samsung_oui]
scope = inline
answer = connectivitycheck.gstatic.com IN A 172.217.13.99
rcode = NOERROR
### END OF SAMSUNG MAC VENDOR CHECK FOR CAPTIVE-PORTAL
EOF

perl -i -e "undef \$/; \$_=<>; s/### SAMSUNG MAC VENDOR CHECK FOR CAPTIVE-PORTAL DO NOT REPLACE ANYTHING BELOW THIS LINE UNTIL THIS BLOCK ENDS\n(.|\n)*\n### END OF SAMSUNG MAC VENDOR CHECK FOR CAPTIVE-PORTAL/$content/m; print" /usr/local/pf/conf/dns_filters.conf.defaults

echo "Done"
