## What is PacketFence?

PacketFence is a fully supported, trusted, Free and Open Source
network access control (NAC) system. Boasting an impressive feature
set including a captive-portal for registration and remediation,
centralized wired and wireless management, 802.1X support, layer-2
isolation of problematic devices, integration with IDS solutions and vulnerability scanners; PacketFence can be used to effectively secure networks - from small to very large heterogeneous networks.

You want to know who is on your network? You want to give different access to your network based on who is connecting? PacketFence is for you!


## Installation

Follow the instructions provided in the [Administration Guide](https://packetfence.org/support/index.html#/documentation).


## More Information

Noteworthy changes since the last release see the [NEWS](https://github.com/inverse-inc/packetfence/blob/devel/NEWS.asciidoc) file.

Upgrading? See the [UPGRADE](https://github.com/inverse-inc/packetfence/blob/devel/UPGRADE.asciidoc) file.

For more details and developer visible changes see the [project's page on Github](https://github.com/inverse-inc/packetfence).

## Support

Join the [community](https://packetfence.org/support/index.html#/community) or request [commercial support](https://packetfence.org/support/index.html#/commercial).

## Contribute

PacketFence is a collaborative effort in order to create the best Open Source NAC solution. There are multiple ways you can contribute to the project.

### *You are a network vendor*

Provide Inverse with switches, access points, wireless controllers, etc. so we can support even more equipment.

### *You are a security software vendor*

Provide Inverse with licenses of your software so we can integrate your IDS, Netflow analyzer, IPS, Web filter, etc. directly into PacketFence and its captive portal technology.

### *You are a PacketFence user*

You can provide:

* Documentation reviews, enhancements and translations
* Share your ideas and participate to the discussion in [mailing lists][mailing_lists]
* Provide Inverse with switches, access points, wireless controllers, etc. so we can support even more equipment

### *You are a developer*

You can provide:

* Documentation reviews, enhancements and translations
* Share your ideas and participate to the discussion in [mailing lists][mailing_lists]
* Patches for bugs or enhancements
* Write tests
* Handle tasks in our Roadmap

### *You are a security researcher*

Push PacketFence into new areas by leveraging the extensibility built into PacketFence. A lot of the low-level plumbing is done for you so you can focus on demoing your ideas. 

Get in touch with us on the developer [mailing list][mailing_lists] with your ideas!

## Source

Feel free to fork our [github repository](https://github.com/inverse-inc/packetfence) if you are willing to contribute.

Most of the development happens in branches. Once ready for integration into [devel](https://github.com/inverse-inc/packetfence/tree/devel), a pull request is opened and a code review takes place. See the list of [all branches in the works](https://github.com/inverse-inc/packetfence/branches).

## Translations

PacketFence is available in various languages. The following list describes the official translations alongside their maintainers:

* English - Inverse inc.
* Brazilian Portuguese - Diego de Souza Lopes
* French - Inverse inc.
* Polish - Maciej Uhlig
* Spanish (Spain) - Dominique Couot

If you would like to translate the software in an other language, please consult the [FAQ](https://packetfence.org/support/faq/article/how-to-translate-packetfence-in-another-language.html).

## License

Licensed under the GNU General Public License v2.

---

[Inverse inc.](https://inverse.ca/) leads the development of the solution. Over the years, numerous people and organizations have contributed to the project and we would like to thank them all !



[mailing_lists]: https://packetfence.org/support/index.html#/community "Community Mailing Lists"
