; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "HashingPasswordFilter"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "Inverse Inc."
!define PRODUCT_WEB_SITE "http://inverse.ca"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
; Registry
!include "Registry.nsh"
!include x64.nsh

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"

!define CSIDL_COMMONAPPDATA '0x23'

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "HashingPasswordFilter.exe"
InstallDir "$WINDIR\system32\"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
  Var /GLOBAL AppDataPath
  System::Call 'shell32::SHGetSpecialFolderPath(i $HWNDPARENT, t .r1, i ${CSIDL_COMMONAPPDATA}, i0)i.r0'
  StrCpy $AppDataPath "$1"
FunctionEnd

Section "Principal" SEC01
  SetOutPath "$TEMP"
  SetOverwrite ifnewer
  File "vcredist_x86.exe"
  FIle "vcredist_x64.exe"
  SetOutPath "$WINDIR\system32"
  SetOverwrite ifnewer
  File "HashingPasswordFilter.dll"
  File "ic_launcher.ico"
  SetOutPath "$AppDataPath"
  SetOverwrite off
  File "HashingPasswordFilter.ini"
  ${registry::Read} "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa\" "Notification Packages" $R0 $R1
  StrCmp $R0 "HashingPasswordFilter" done
  strCpy $R3 "$R0$\nHashingPasswordFilter"
  registry::_CopyValue /NOUNLOAD "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa" "Notification Packages" "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa" "Notification Packages Back"
  registry::_Write /NOUNLOAD "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa\" "Notification Packages" $R3 "REG_MULTI_SZ"
  done:
  ${If} ${RunningX64}
    ReadRegStr $1 HKLM "SOFTWARE\Microsoft\VisualStudio\12.0\VC\VCRedist\x64" "Installed"
    StrCmp $1 1 installed
    ExecWait "$TEMP\vcredist_x64.exe"
  ${Else}
    ReadRegStr $1 HKLM "SOFTWARE\Microsoft\VisualStudio\12.0\VC\VCRedist\x86" "Installed"
    StrCmp $1 1 installed
    ExecWait "$TEMP\vcredist_x86.exe"
  ${EndIf}
  installed:

SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\ic_launcher.ico"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) a t dsinstall avec succs de votre ordinateur."
FunctionEnd

Function un.onInit
  Var /GLOBAL AppDataPath2
  System::Call 'shell32::SHGetSpecialFolderPath(i $HWNDPARENT, t .r1, i ${CSIDL_COMMONAPPDATA}, i0)i.r0'
  StrCpy $AppDataPath2 "$1"
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "tes-vous certains de vouloir dsinstaller totalement $(^Name) et tous ses composants ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\uninst.exe"
  Delete "$AppDataPath2\HashingPasswordFilter.ini"
  Delete "$WINDIR\system32\HashingPasswordFilter.dll"
  ${registry::Read} "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa\" "Notification Packages" $R0 $R1
  StrCmp $R0 "HashingPasswordFilter" 0 +2
  registry::_DeleteValue /NOUNLOAD "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa\" "Notification Packages"
  registry::_MoveValue /NOUNLOAD "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa" "Notification Packages Back" "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa" "Notification Packages"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd